"use strict";

exports.__esModule = true;
exports.transform = transform;
exports.conflicts = conflicts;
exports.conflictsAny = conflictsAny;

/**
 * Matches `.`, `-`, or `_`
 */
var punctuationRegex = /[.\-_]/g;

function transform(name) {
  return name.replace(punctuationRegex, "").toLowerCase();
}

function conflicts(nameA, nameB) {
  return transform(nameA) === transform(nameB);
}

function conflictsAny(name, names) {
  var _names$find;

  var nameTransform = transform(name);
  return (_names$find = names.find(function (item) {
    return nameTransform === transform(item);
  })) != null ? _names$find : false;
}