"use strict";

exports.__esModule = true;
exports.getLock = getLock;

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function getLock(options) {
  if (options === void 0) {
    options = {};
  }

  var queue = {};

  function startNext(key) {
    var _queue$key$;

    var releaseFn = function releaseFn() {
      queue[key].shift();
      startNext(key);
    };

    (_queue$key$ = queue[key][0]) == null ? void 0 : _queue$key$.start(releaseFn);
  }

  return /*#__PURE__*/function () {
    var _ref = _asyncToGenerator(function* (key) {
      if (key === void 0) {
        key = "";
      }

      if (queue[key] === undefined) {
        queue[key] = [];
      }

      return new Promise(function (start, reject) {
        if (options.replace && queue[key].length > 1) {
          queue[key][1].reject();
          queue[key][1] = {
            start: start,
            reject: reject
          };
        } else {
          queue[key].push({
            start: start,
            reject: reject
          });
        }

        if (queue[key].length === 1) {
          return startNext(key);
        } else {
          return undefined;
        }
      });
    });

    return function (_x) {
      return _ref.apply(this, arguments);
    };
  }();
}