export declare type ReleaseFn = () => void;
export declare type Lock = (key?: string) => Promise<ReleaseFn>;
export declare type LockOptions = {
    /**
     * When aquiring a lock for some key, replace first promise in line rather than adding to queue.
     * Replaced promise will be rejected.
     * Default: `false`
     */
    replace?: boolean;
};
export declare function getLock(options?: LockOptions): (key?: string) => Promise<ReleaseFn>;
