# is-url-superb

> Check if a string is a URL

## Install

```
$ npm install is-url-superb
```

## Usage

```js
import isUrl from 'is-url-superb';

isUrl('https://sindresorhus.com');
//=> true

isUrl('unicorn');
//=> false
```

## API

### isUrl(string, options?)

#### options

Type: `object`

##### lenient

Type: `boolean`\
Default: `false`

Allow URLs without a protocol.

```js
import isUrl from 'is-url-superb';

isUrl('example.com');
//=> false

isUrl('example.com', {lenient: true});
//=> true
```

## Related

- [is](https://github.com/sindresorhus/is) - Type check values
