"use strict";

exports.__esModule = true;
exports.isValid = isValid;
exports.isTaken = isTaken;

var _allPackageNames = require("all-package-names");

var _validateNpmPackageName = _interopRequireDefault(require("validate-npm-package-name"));

var _packageNameConflict = require("package-name-conflict");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function isValid(name) {
  return (0, _validateNpmPackageName["default"])(name).validForNewPackages;
}

function getSave(options) {
  if (options != null && options.optimistic) {
    return (0, _allPackageNames.load)(options);
  } else {
    return (0, _allPackageNames.sync)(options);
  }
}

function isTaken(_x, _x2) {
  return _isTaken.apply(this, arguments);
}

function _isTaken() {
  _isTaken = _asyncToGenerator(function* (name, options) {
    if (isValid(name)) {
      return getSave(options).then(function (_ref) {
        var packageNames = _ref.packageNames;
        return (0, _packageNameConflict.conflictsAny)(name, packageNames);
      });
    } else {
      return Promise.resolve(true);
    }
  });
  return _isTaken.apply(this, arguments);
}