import { LoadOptions } from "all-package-names";
export declare type Options = LoadOptions & {
    /**
     * Setting optimistic to true will skip syncing latest packages from NPM.
     * This is faster, but may lead to inconsistencies with recently published packages.
     */
    optimistic?: boolean;
};
export declare function isValid(name: string): boolean;
export declare function isTaken(name: string, options?: Options): Promise<string | boolean>;
