"use strict";

exports.__esModule = true;
exports["default"] = _default;
exports.createCommand = void 0;

var _commander = _interopRequireWildcard(require("commander"));

exports.commander = _commander["default"];

var _module = require("@bconnorwhite/module");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Set the program version to `version` from the nearest package.json up from `dirname`.
 *
 * This method auto-registers the "-v, --version" flag
 * which will print the version number when passed.
 *
 * You can optionally supply the  flags and description to override the defaults.
 */
function _default(dirname, flags, description) {
  if (flags === void 0) {
    flags = "-v --version";
  }

  var version = (0, _module.getVersionSync)(dirname);

  if (version) {
    return new _commander.Command().version(version, flags, description);
  } else {
    return new _commander.Command();
  }
}

var createCommand = _commander["default"].createCommand;
exports.createCommand = createCommand;