import { Save, LoadOptions } from "./load";
export declare type State = {
    /**
     * Starting package sync index
     */
    start: number;
    /**
     * Current package sync index
     */
    index: number;
    /**
     * Ending package sync index
     */
    end: number;
    /**
     * Percentage of sync completed
     */
    progress: number;
    /**
     * Milliseconds since sync began
     */
    elapsed: number;
    /**
     * Set of package names that have been added
     */
    packageNames: Set<string>;
    /**
     * Milliseconds since last save
     */
    lastSave: number;
};
export declare type StateHook = (state: State) => void;
export declare type SyncOptions = {
    onStart?: StateHook;
    onData?: StateHook;
    onEnd?: StateHook;
} & LoadOptions;
export declare function sync({ onData, onStart, onEnd, maxAge }?: SyncOptions): Promise<Save>;
export declare function syncAction(options?: LoadOptions): void;
declare const _default: import("commander").Command;
export default _default;
