"use strict";

exports.__esModule = true;
exports.save = save;
exports.isFresh = isFresh;
exports.load = load;

var _nodeFs = require("node:fs");

var _nodeZlib = require("node:zlib");

var _nodeUtil = require("node:util");

var _nodeStream = require("node:stream");

var _typesJson = require("types-json");

var _ = require("./");

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function isPositiveNumber(value) {
  return typeof value === "number" && value >= 0;
}

function filterStringArray(array) {
  return array.filter(function (value) {
    return typeof value === "string";
  });
}

var saveTemplate = {
  since: 0,
  timestamp: 0,
  packageNames: []
};
var cache;

function readJsonGz(filename) {
  return new Promise(function (resolve, reject) {
    var gunzip = (0, _nodeZlib.createGunzip)();
    var readStream = (0, _nodeFs.createReadStream)(filename);
    readStream.on('error', function (err) {
      resolve(undefined);
    });
    gunzip.on('error', function (err) {
      resolve(undefined);
    });
    var json = "";
    readStream.pipe(gunzip);
    gunzip.on("data", function (chunk) {
      json += chunk.toString();
    });
    gunzip.on("end", function () {
      try {
        resolve(JSON.parse(json));
      } catch (err) {
        resolve(undefined);
      }
    });
  });
}

function writeJsonGz(_x, _x2) {
  return _writeJsonGz.apply(this, arguments);
}

function _writeJsonGz() {
  _writeJsonGz = _asyncToGenerator(function* (filename, save) {
    var readable = _nodeStream.Readable.from([JSON.stringify(save)]);

    var gzip = (0, _nodeZlib.createGzip)();
    var writeStream = (0, _nodeFs.createWriteStream)(filename);
    var pipe = (0, _nodeUtil.promisify)(_nodeStream.pipeline);
    yield pipe(readable, gzip, writeStream);
  });
  return _writeJsonGz.apply(this, arguments);
}

function save(_x3) {
  return _save.apply(this, arguments);
}

function _save() {
  _save = _asyncToGenerator(function* (data) {
    cache = data;
    return writeJsonGz(_.savePath, data);
  });
  return _save.apply(this, arguments);
}

function isFresh(_ref, maxAge) {
  var timestamp = _ref.timestamp;

  if (maxAge === void 0) {
    maxAge = 0;
  }

  return timestamp + maxAge > new Date().getTime();
}

function load(_x4) {
  return _load.apply(this, arguments);
}

function _load() {
  _load = _asyncToGenerator(function* (options) {
    if (cache !== undefined && isFresh(cache, options == null ? void 0 : options.maxAge)) {
      return Promise.resolve(cache);
    } else {
      var data = yield readJsonGz(_.savePath);

      if ((0, _typesJson.isJSONObject)(data)) {
        cache = {
          since: isPositiveNumber(data.since) ? data.since : saveTemplate.since,
          timestamp: isPositiveNumber(data.timestamp) ? data.timestamp : saveTemplate.timestamp,
          packageNames: Array.isArray(data.packageNames) ? filterStringArray(data.packageNames) : saveTemplate.packageNames
        };
      } else {
        cache = saveTemplate;
      }

      return cache;
    }
  });
  return _load.apply(this, arguments);
}