export declare type Save = {
    /**
     * Index of last package synced
     */
    since: number;
    /**
     * Timestamp of last sync
     */
    timestamp: number;
    /**
     * Array of package names
     */
    packageNames: string[];
};
export declare type LoadOptions = {
    /**
     * Maximum milliseconds after a sync to avoid re-syncing
     */
    maxAge?: number;
};
export declare function save(data: Save): Promise<void>;
export declare function isFresh({ timestamp }: Save, maxAge?: number): boolean;
export declare function load(options?: LoadOptions): Promise<Save>;
