const minify = require('./minify')
const filters = require('./filters')
const inline = require('./inlineCss')
const markdown = require('./markdown')
const prettify = require('./prettify')
const ensureSixHEX = require('./sixHex')
const applyBaseUrl = require('./baseUrl')
const posthtmlMSO = require('./posthtmlMso')
const addURLParams = require('./urlParameters')
const preventWidows = require('./preventWidows')
const replaceStrings = require('./replaceStrings')
const safeClassNames = require('./safeClassNames')
const removeUnusedCSS = require('./removeUnusedCss')
const removeAttributes = require('./removeAttributes')
const attributeToStyle = require('./attributeToStyle')
const removeInlineSizes = require('./removeInlineSizes')
const applyExtraAttributes = require('./extraAttributes')
const shorthandInlineCSS = require('./shorthandInlineCSS')
const removeInlinedClasses = require('./removeInlinedSelectors')
const removeInlineBgColor = require('./removeInlineBackgroundColor')

exports.process = async (html, config) => {
  html = await safeClassNames(html, config)
  html = await filters(html, config)
  html = await markdown(html, config)
  html = await preventWidows(html, config)
  html = await attributeToStyle(html, config)
  html = await inline(html, config)
  html = await removeUnusedCSS(html, config)
  html = await shorthandInlineCSS(html, config)
  html = await removeInlineSizes(html, config)
  html = await removeInlineBgColor(html, config)
  html = await removeAttributes(html, config)
  html = await applyExtraAttributes(html, config)
  html = await applyBaseUrl(html, config)
  html = await addURLParams(html, config)
  html = await ensureSixHEX(html, config)
  html = await posthtmlMSO(html, config)
  html = await prettify(html, config)
  html = await minify(html, config)
  html = await replaceStrings(html, config)

  return html
}

exports.minify = (html, config) => minify(html, config, true)
exports.inlineCSS = (html, config) => inline(html, config, true)
exports.markdown = (html, config) => markdown(html, config, true)
exports.prettify = (html, config) => prettify(html, config, true)
exports.ensureSixHEX = (html, config) => ensureSixHEX(html, config)
exports.withFilters = (html, config) => filters(html, config, true)
exports.addURLParams = (html, config) => addURLParams(html, config, true)
exports.preventWidows = (html, config) => preventWidows(html, config)
exports.replaceStrings = (html, config) => replaceStrings(html, config, true)
exports.safeClassNames = (html, config) => safeClassNames(html, config, true)
exports.removeUnusedCSS = (html, config) => removeUnusedCSS(html, config, true)
exports.removeAttributes = (html, config) => removeAttributes(html, config, true)
exports.attributeToStyle = (html, config) => attributeToStyle(html, config, true)
exports.removeInlineSizes = (html, config) => removeInlineSizes(html, config, true)
exports.applyBaseUrl = (html, config) => applyBaseUrl(html, config, true)
exports.removeInlinedClasses = (html, config) => removeInlinedClasses(html, config)
exports.shorthandInlineCSS = (html, config) => shorthandInlineCSS(html, config, true)
exports.removeInlineBgColor = (html, config) => removeInlineBgColor(html, config, true)
exports.applyExtraAttributes = (html, config) => applyExtraAttributes(html, config, true)
