"use strict";

exports.__esModule = true;
exports.getPackageJSONSync = getPackageJSONSync;
exports.getPackageJSON = getPackageJSON;

var _findUp = _interopRequireWildcard(require("find-up"));

var _typesPkgJson = require("types-pkg-json");

exports.PackageJSON = _typesPkgJson.PackageJSON;

var _readJsonSafe = require("read-json-safe");

var _version = require("./version");

exports.getVersion = _version.getVersion;
exports.getVersionSync = _version.getVersionSync;

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function getPackageJSONSync(dirname) {
  var path = (0, _findUp.sync)(_typesPkgJson.fileName, {
    cwd: dirname
  });

  if (path !== undefined) {
    return (0, _readJsonSafe.readJSONFileSync)(path);
  }
}

function getPackageJSON(_x) {
  return _getPackageJSON.apply(this, arguments);
}

function _getPackageJSON() {
  _getPackageJSON = _asyncToGenerator(function* (dirname) {
    return (0, _findUp["default"])(_typesPkgJson.fileName, {
      cwd: dirname
    }).then(function (path) {
      if (path !== undefined) {
        return (0, _readJsonSafe.readJSONFile)(path);
      }
    });
  });
  return _getPackageJSON.apply(this, arguments);
}